//
//  UnlockViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class UnlockViewController: BaseViewController {

    @IBOutlet weak var unlockPinField: UITextField!
    @IBOutlet weak var pinContainerView: UIView!
    @IBOutlet weak var pinField: UITextField!
    @IBOutlet weak var pinConfirmationField: UITextField!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Unlock"
        
        pinContainerView.isHidden = true
    }
    
    func startUnlock(code: String) {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startUnlock(code: code)
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.pinContainerView.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    func finalizeUnlock(code: String, pin: String) {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.finalizeUnlock(code: code, pin: pin)
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.showAlert(title: "Unlock", message: "Success")
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    @IBAction func unlockTouched(_ sender: Any) {
        let code = unlockPinField.text ?? ""
        startUnlock(code: code)
    }
    
    @IBAction func validatePinTouched(_ sender: Any) {
        let code = unlockPinField.text ?? ""
        let newPin = self.pinField.text ?? ""
        let newPinConfirmation = self.pinConfirmationField.text ?? ""
        
        guard newPin.isValidPin() else {
            self.showAlert(title: "Error", message: "PIN must be 4 digits minimum, 6 maximum")
            return
        }
        
        guard newPinConfirmation == newPin else {
            self.showAlert(title: "Error", message: "PIN values are not the same")
            return
        }
        
        finalizeUnlock(code: code, pin: newPin)
    }
}
